<?php if( !defined('ABSPATH') ) exit('Restricted Access'); ?>

<?php $property_meta = _WSH()->get_meta();

if( !sh_set( $property_meta, 'related_properties' ) ) return;


$terms = get_the_terms(get_the_id(), 'property_category' ); 
$first_tag = current( (array) $terms );

$args=array(
	'property_category' => $first_tag->slug,
	'post__not_in' => array($post->ID),
	'posts_per_page'=>3,
	'ignore_sticky_posts'=>1
);

$my_query = new WP_Query($args);?>

<?php if( $my_query->have_posts() ): ?>	

	<!--======= PROPERTY =========-->
	<section class="properties white-bg">
		<div class="container"> 

			<!--======= TITTLE =========-->
			<div class="tittle"> <img src="<?php  echo $top_heading_img;  ?>" alt="">
				<h3><?php echo sh_set($options, 'sh_property_title');?></h3>
				<p><?php echo sh_set($options, 'sh_property_subtitle');?></p>
			</div>

			<!--======= PROPERTIES ROW =========-->
			<ul class="row">

				<?php while( $my_query->have_posts() ): $my_query->the_post(); 
					
					$property_meta = _WSH()->get_meta();
					$agents_term = get_the_terms(get_the_id(), 'property_agent');
					if( $agents_term )
						$meta = _WSH()->get_term_meta('_sh_property_agent_settings'.$agents_term[0]->term_id);
					else $meta = array();	
					?>
					
					<!--======= PROPERTY =========-->
					<li class="col-sm-4"> 
						<!--======= TAGS =========-->

						<section> 
							<!--======= IMAGE =========-->
							<div class="img"> 
								<?php the_post_thumbnail('370x230', array('class' => 'img-responsive'));?>
								<!--======= IMAGE HOVER =========-->

								<div class="over-proper"> <a href="<?php the_permalink();?>" class="btn font-montserrat"><?php esc_html_e('more details', 'realtor');?></a> </div>
							</div>
							<!--======= HOME INNER DETAILS =========-->
							<ul class="home-in">
								<li><span><i class="fa fa-home"></i> <?php echo sh_set($property_meta, 'area');?></span></li>
								<li><span><i class="fa fa-bed"></i> <?php echo sh_set($property_meta, 'bedrooms');?></span></li>
								<li><span><i class="fa fa-tty"></i> <?php echo sh_set($property_meta, 'bathrooms');?></span></li>
							</ul>
							<!--======= HOME DETAILS =========-->
							<div class="detail-sec"> <a href="<?php the_permalink();?>" class="font-montserrat"><?php the_title();?></a> <span class="locate"><i class="fa fa-map-marker"></i> <?php echo sh_set($property_meta, 'address');?></span> <span class="price-bg  font-montserrat"><?php echo sh_set($property_meta, 'price');?></span> <a href="<?php the_permalink();?>" class="btn"><?php esc_html_e('more details', 'realtor');?></a> </div>
						</section>
					</li>

				<?php endwhile;?>

			</ul>
		</div>
	</section>

<?php endif;?>


<?php wp_reset_postdata();