<?php
$sh_sc = array();
$sh_sc['sh_search']	=	array(
					"name" => __("Search Box", SH_NAME),
					"base" => "sh_search",
					"class" => "",
					"category" => __('Realtor', SH_NAME),
					"icon" => 'fa-briefcase' ,
					'description' => __('Show Search Box.', SH_NAME),
					"params" => array(
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Title', SH_NAME ),
						   "param_name" => "title",
						   "value" => "",
						   "description" => __('Enter the title or leave empty for none.', SH_NAME ),
						),
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Minimum Price', SH_NAME ),
						   "param_name" => "min",
						   "value" => "",
						   "description" => __('Enter the Minimum Price.', SH_NAME ),
						),
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Maximum Price', SH_NAME ),
						   "param_name" => "max",
						   "value" => "",
						   "description" => __('Enter the Maximum Price.', SH_NAME ),
						),
					)
				);

$sh_sc['sh_property1']	=	array(
					"name" => __("Property 1", SH_NAME),
					"base" => "sh_property1",
					"class" => "",
					"category" => __('Realtor', SH_NAME),
					"icon" => 'fa-briefcase' ,
					'description' => __('Show Properties Two Column.', SH_NAME),
					"params" => array(
						
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Number', SH_NAME ),
						   "param_name" => "num",
						   "description" => __('Enter Number of properties to Show.', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "dropdown",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __( 'Category', SH_NAME ),
						   "param_name" => "cat",
						   "value" => array_flip( (array)sh_get_categories( array( 'taxonomy' => 'property_category', 'hide_empty' => FALSE ), true ) ),
						   "description" => __( 'Choose Category.', SH_NAME ),
						),
						array(
						   "type" => "dropdown",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __("Order By", SH_NAME),
						   "param_name" => "sort",
						   'value' => array_flip( array('date'=>__('Date', SH_NAME),'title'=>__('Title', SH_NAME) ,'name'=>__('Name', SH_NAME) ,'author'=>__('Author', SH_NAME),'comment_count' =>__('Comment Count', SH_NAME),'random' =>__('Random', SH_NAME) ) ),			
						   "description" => __("Enter the sorting order.", SH_NAME),
						),
						array(
						   "type" => "dropdown",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __("Order", SH_NAME),
						   "param_name" => "order",
						   'value' => array_flip(array('ASC'=>__('Ascending', SH_NAME),'DESC'=>__('Descending', SH_NAME) ) ),			
						   "description" => __("Enter the sorting order.", SH_NAME),
						),
					)
				);
$sh_sc['sh_services']	=	array(
					"name" => __("Services", SH_NAME),
					"base" => "sh_services",
					"class" => "",
					"category" => __('Realtor', SH_NAME),
					"icon" => 'fa-briefcase' ,
					'description' => __('Show Service.', SH_NAME),
					"params" => array(
						
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Title', SH_NAME ),
						   "param_name" => "title",
						   "description" => __('Enter Title to Show.', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "textarea",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Text', SH_NAME ),
						   "param_name" => "text",
						   "description" => __('Enter Text to Show.', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Number', SH_NAME ),
						   "param_name" => "num",
						   "description" => __('Enter Number of Services to Show.', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Text Limit', SH_NAME ),
						   "param_name" => "text_limit",
						   "description" => __('Enter text limit of Services to Show.', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "dropdown",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __( 'Category', SH_NAME ),
						   "param_name" => "cat",
						   "value" => array_flip( (array)sh_get_categories( array( 'taxonomy' => 'services_category', 'hide_empty' => FALSE ), true ) ),
						   "description" => __( 'Choose Category.', SH_NAME ),
						),
						array(
						   "type" => "dropdown",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __("Order By", SH_NAME),
						   "param_name" => "sort",
						   'value' => array_flip( array('date'=>__('Date', SH_NAME),'title'=>__('Title', SH_NAME) ,'name'=>__('Name', SH_NAME) ,'author'=>__('Author', SH_NAME),'comment_count' =>__('Comment Count', SH_NAME),'random' =>__('Random', SH_NAME) ) ),			
						   "description" => __("Enter the sorting order.", SH_NAME),
						),
						array(
						   "type" => "dropdown",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __("Order", SH_NAME),
						   "param_name" => "order",
						   'value' => array_flip(array('ASC'=>__('Ascending', SH_NAME),'DESC'=>__('Descending', SH_NAME) ) ),			
						   "description" => __("Enter the sorting order.", SH_NAME),
						),
					)
				);
$sh_sc['sh_property2']	=	array(
					"name" => __("Property 2", SH_NAME),
					"base" => "sh_property2",
					"class" => "",
					"category" => __('Realtor', SH_NAME),
					"icon" => 'fa-briefcase' ,
					'description' => __('Show Properties Three column.', SH_NAME),
					"params" => array(
						
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Title', SH_NAME ),
						   "param_name" => "title",
						   "description" => __('Enter Title to Show.', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "textarea",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Text', SH_NAME ),
						   "param_name" => "text",
						   "description" => __('Enter Text to Show.', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Text Limit', SH_NAME ),
						   "param_name" => "text_limit",
						   "description" => __('Enter text limit of Services to Show.', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Number', SH_NAME ),
						   "param_name" => "num",
						   "description" => __('Enter Number of properties to Show.', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "dropdown",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __( 'Category', SH_NAME ),
						   "param_name" => "cat",
						   "value" => array_flip( (array)sh_get_categories( array( 'taxonomy' => 'property_category', 'hide_empty' => FALSE ), true ) ),
						   "description" => __( 'Choose Category.', SH_NAME ),
						),
						array(
						   "type" => "dropdown",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __("Order By", SH_NAME),
						   "param_name" => "sort",
						   'value' => array_flip( array('date'=>__('Date', SH_NAME),'title'=>__('Title', SH_NAME) ,'name'=>__('Name', SH_NAME) ,'author'=>__('Author', SH_NAME),'comment_count' =>__('Comment Count', SH_NAME),'random' =>__('Random', SH_NAME) ) ),			
						   "description" => __("Enter the sorting order.", SH_NAME),
						),
						array(
						   "type" => "dropdown",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __("Order", SH_NAME),
						   "param_name" => "order",
						   'value' => array_flip(array('ASC'=>__('Ascending', SH_NAME),'DESC'=>__('Descending', SH_NAME) ) ),			
						   "description" => __("Enter the sorting order.", SH_NAME),
						),
					)
				);
$sh_sc['sh_team']	=	array(
					"name" => __("Team", SH_NAME),
					"base" => "sh_team",
					"class" => "",
					"category" => __('Realtor', SH_NAME),
					"icon" => 'fa-briefcase' ,
					'description' => __('Show Teams.', SH_NAME),
					"params" => array(
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Title', SH_NAME ),
						   "param_name" => "title",
						   "description" => __('Enter the title or leave empty for none.', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "textarea",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Text', SH_NAME ),
						   "param_name" => "text",
						   "description" => __('Enter the Text or leave empty for none.', SH_NAME ),
						   "value" => "",
						   
						),
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Number', SH_NAME ),
						   "param_name" => "num",
						   "description" => __('Enter Number of Services to Show.', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "dropdown",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __( 'Category', SH_NAME ),
						   "param_name" => "cat",
						   "value" => array_flip( (array)sh_get_categories( array( 'taxonomy' => 'team_category', 'hide_empty' => FALSE ), true ) ),
						   "description" => __( 'Choose Category.', SH_NAME ),
						),
						array(
						   "type" => "dropdown",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __("Order By", SH_NAME),
						   "param_name" => "sort",
						   'value' => array_flip( array('date'=>__('Date', SH_NAME),'title'=>__('Title', SH_NAME) ,'name'=>__('Name', SH_NAME) ,'author'=>__('Author', SH_NAME),'comment_count' =>__('Comment Count', SH_NAME),'random' =>__('Random', SH_NAME) ) ),			
						   "description" => __("Enter the sorting order.", SH_NAME),
						),
						array(
						   "type" => "dropdown",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __("Order", SH_NAME),
						   "param_name" => "order",
						   'value' => array_flip(array('ASC'=>__('Ascending', SH_NAME),'DESC'=>__('Descending', SH_NAME) ) ),			
						   "description" => __("Enter the sorting order.", SH_NAME),
						),
						
					)
				);
$sh_sc['sh_testimonial']	=	array(
		"name" => __("Testimonials", SH_NAME),
		"base" => "sh_testimonial",
		"class" => "",
		"category" => __('Realtor', SH_NAME),
		"icon" => 'fa-briefcase' ,
		'description' => __('Show testimonials.', SH_NAME),
		"params" => array(
			array(
			   "type" => "textfield",
			   "holder" => "div",
			   "class" => "",
			   "heading" => __('Title', SH_NAME ),
			   "param_name" => "title",
			   "description" => __('Enter Title of testimonials to Show.', SH_NAME ),
			   "value" => "",
			),
			array(
			   "type" => "textfield",
			   "holder" => "div",
			   "class" => "",
			   "heading" => __('Text Limit', SH_NAME ),
			   "param_name" => "text_limit",
			   "description" => __('Enter text_limit of testimonials to Show.', SH_NAME ),
			   "value" => "",
			),
			array(
			   "type" => "textfield",
			   "holder" => "div",
			   "class" => "",
			   "heading" => __('Number', SH_NAME ),
			   "param_name" => "num",
			   "description" => __('Enter Number of testimonials to Show.', SH_NAME ),
			   "value" => "",
			),
		
			array(
			   "type" => "dropdown",
			   "holder" => "div",
			   "class" => "",
			   "heading" => __( 'Category', SH_NAME ),
			   "param_name" => "cat",
			   "value" => array_flip( (array)sh_get_categories( array( 'taxonomy' => 'testimonial_category', 'hide_empty' => FALSE ), true ) ),
			   "description" => __( 'Choose Category.', SH_NAME ),
			),
			array(
			   "type" => "dropdown",
			   "holder" => "div",
			   "class" => "",
			   "heading" => __("Order By", SH_NAME),
			   "param_name" => "sort",
			   'value' => array_flip( array('date'=>__('Date', SH_NAME),'title'=>__('Title', SH_NAME) ,'name'=>__('Name', SH_NAME) ,'author'=>__('Author', SH_NAME),'comment_count' =>__('Comment Count', SH_NAME),'random' =>__('Random', SH_NAME) ) ),			
			   "description" => __("Enter the sorting order.", SH_NAME),
			),
			array(
			   "type" => "dropdown",
			   "holder" => "div",
			   "class" => "",
			   "heading" => __("Order", SH_NAME),
			   "param_name" => "order",
			   'value' => array_flip(array('ASC'=>__('Ascending', SH_NAME),'DESC'=>__('Descending', SH_NAME) ) ),			
			   "description" => __("Enter the sorting order.", SH_NAME),
			),
		)
	);
$sh_sc['sh_call_to_action']	=	array(
					"name" => __("Call To Action", SH_NAME),
					"base" => "sh_call_to_action",
					"class" => "",
					"category" => __('Realtor', SH_NAME),
					"icon" => 'fa-briefcase' ,
					'description' => __('Show Call to action.', SH_NAME),
					"params" => array(
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Title', SH_NAME ),
						   "param_name" => "title",
						   "description" => __('Enter the title or leave empty for none.', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Sub-Title', SH_NAME ),
						   "param_name" => "subtitle",
						   "description" => __('Enter the sub-title or leave empty for none.', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Phone', SH_NAME ),
						   "param_name" => "phone",
						   "description" => __('Enter Phone number to Show.', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Button Link', SH_NAME ),
						   "param_name" => "btn_link",
						   "description" => __('Enter Button Link', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Button Text', SH_NAME ),
						   "param_name" => "btn_text",
						   "description" => __('Enter Button Text', SH_NAME ),
						   "value" => "",
						),
						
					)
				);
$sh_sc['sh_blog']	=	array(
					"name" => __("Our Blog", SH_NAME),
					"base" => "sh_blog",
					"class" => "",
					"category" => __('Realtor', SH_NAME),
					"icon" => 'fa-briefcase',
					'description' => __('Show Blog Posts', SH_NAME),
					"params" => array(
						
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Title', SH_NAME ),
						   "param_name" => "title",
						   "description" => __('Enter Title of Posts to Show.', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Text Limit', SH_NAME ),
						   "param_name" => "text_limit",
						   "description" => __('Enter Text limit of Posts to Show.', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Number', SH_NAME ),
						   "param_name" => "num",
						   "description" => __('Enter Number of posts to Show.', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "dropdown",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __( 'Category', SH_NAME ),
						   "param_name" => "cat",
						   "value" => array_flip( (array)sh_get_categories( array( 'taxonomy' => 'category', 'hide_empty' => FALSE ), true ) ),
						   "description" => __( 'Choose Category.', SH_NAME ),
						),
						array(
						   "type" => "dropdown",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __("Order By", SH_NAME),
						   "param_name" => "sort",
						   'value' => array_flip( array('date'=>__('Date', SH_NAME),'title'=>__('Title', SH_NAME) ,'name'=>__('Name', SH_NAME) ,'author'=>__('Author', SH_NAME),'comment_count' =>__('Comment Count', SH_NAME),'random' =>__('Random', SH_NAME) ) ),			
						   "description" => __("Enter the sorting order.", SH_NAME),
						),
						array(
						   "type" => "dropdown",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __("Order", SH_NAME),
						   "param_name" => "order",
						   'value' => array_flip(array('ASC'=>__('Ascending', SH_NAME),'DESC'=>__('Descending', SH_NAME) ) ),			
						   "description" => __("Enter the sorting order.", SH_NAME),
						),
					)
				);
$sh_sc['sh_property3']	=	array(
					"name" => __("Property 3", SH_NAME),
					"base" => "sh_property3",
					"class" => "",
					"category" => __('Realtor', SH_NAME),
					"icon" => 'fa-briefcase' ,
					'description' => __('Show Properties 3 column simple.', SH_NAME),
					"params" => array(
						
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Title', SH_NAME ),
						   "param_name" => "title",
						   "description" => __('Enter Title to Show.', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "textarea",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Text', SH_NAME ),
						   "param_name" => "text",
						   "description" => __('Enter Text to Show.', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Number', SH_NAME ),
						   "param_name" => "num",
						   "description" => __('Enter Number of properties to Show.', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "dropdown",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __( 'Category', SH_NAME ),
						   "param_name" => "cat",
						   "value" => array_flip( (array)sh_get_categories( array( 'taxonomy' => 'property_category', 'hide_empty' => FALSE ), true ) ),
						   "description" => __( 'Choose Category.', SH_NAME ),
						),
						array(
						   "type" => "dropdown",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __("Order By", SH_NAME),
						   "param_name" => "sort",
						   'value' => array_flip( array('date'=>__('Date', SH_NAME),'title'=>__('Title', SH_NAME) ,'name'=>__('Name', SH_NAME) ,'author'=>__('Author', SH_NAME),'comment_count' =>__('Comment Count', SH_NAME),'random' =>__('Random', SH_NAME) ) ),			
						   "description" => __("Enter the sorting order.", SH_NAME),
						),
						array(
						   "type" => "dropdown",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __("Order", SH_NAME),
						   "param_name" => "order",
						   'value' => array_flip(array('ASC'=>__('Ascending', SH_NAME),'DESC'=>__('Descending', SH_NAME) ) ),			
						   "description" => __("Enter the sorting order.", SH_NAME),
						),
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Button Link', SH_NAME ),
						   "param_name" => "btn_link",
						   "description" => __('Enter Button Link to Show.', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Button Text', SH_NAME ),
						   "param_name" => "btn_text",
						   "description" => __('Enter Button Text to Show.', SH_NAME ),
						   "value" => "",
						),
					)
				);
$sh_sc['sh_testimonial2']	=	array(
		"name" => __("Testimonials 2", SH_NAME),
		"base" => "sh_testimonial2",
		"class" => "",
		"category" => __('Realtor', SH_NAME),
		"icon" => 'fa-briefcase' ,
		'description' => __('Show testimonials.', SH_NAME),
		"params" => array(
			array(
			   "type" => "textfield",
			   "holder" => "div",
			   "class" => "",
			   "heading" => __('Title', SH_NAME ),
			   "param_name" => "title",
			   "description" => __('Enter Title of testimonials to Show.', SH_NAME ),
			   "value" => "",
			),
			array(
			   "type" => "textfield",
			   "holder" => "div",
			   "class" => "",
			   "heading" => __('Text Limit', SH_NAME ),
			   "param_name" => "text_limit",
			   "description" => __('Enter text_limit of testimonials to Show.', SH_NAME ),
			   "value" => "",
			),
			array(
			   "type" => "textfield",
			   "holder" => "div",
			   "class" => "",
			   "heading" => __('Number', SH_NAME ),
			   "param_name" => "num",
			   "description" => __('Enter Number of testimonials to Show.', SH_NAME ),
			   "value" => "",
			),
		
			array(
			   "type" => "dropdown",
			   "holder" => "div",
			   "class" => "",
			   "heading" => __( 'Category', SH_NAME ),
			   "param_name" => "cat",
			   "value" => array_flip( (array)sh_get_categories( array( 'taxonomy' => 'testimonial_category', 'hide_empty' => FALSE ), true ) ),
			   "description" => __( 'Choose Category.', SH_NAME ),
			),
			array(
			   "type" => "dropdown",
			   "holder" => "div",
			   "class" => "",
			   "heading" => __("Order By", SH_NAME),
			   "param_name" => "sort",
			   'value' => array_flip( array('date'=>__('Date', SH_NAME),'title'=>__('Title', SH_NAME) ,'name'=>__('Name', SH_NAME) ,'author'=>__('Author', SH_NAME),'comment_count' =>__('Comment Count', SH_NAME),'random' =>__('Random', SH_NAME) ) ),			
			   "description" => __("Enter the sorting order.", SH_NAME),
			),
			array(
			   "type" => "dropdown",
			   "holder" => "div",
			   "class" => "",
			   "heading" => __("Order", SH_NAME),
			   "param_name" => "order",
			   'value' => array_flip(array('ASC'=>__('Ascending', SH_NAME),'DESC'=>__('Descending', SH_NAME) ) ),			
			   "description" => __("Enter the sorting order.", SH_NAME),
			),
		)
	);
$sh_sc['sh_property4']	=	array(
					"name" => __("Property 4", SH_NAME),
					"base" => "sh_property4",
					"class" => "",
					"category" => __('Realtor', SH_NAME),
					"icon" => 'fa-briefcase' ,
					'description' => __('Show Properties 1 column.', SH_NAME),
					"params" => array(
						
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Title', SH_NAME ),
						   "param_name" => "title",
						   "description" => __('Enter Title to Show.', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Number', SH_NAME ),
						   "param_name" => "num",
						   "description" => __('Enter Number of properties to Show.', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "dropdown",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __( 'Category', SH_NAME ),
						   "param_name" => "cat",
						   "value" => array_flip( (array)sh_get_categories( array( 'taxonomy' => 'property_category', 'hide_empty' => FALSE ), true ) ),
						   "description" => __( 'Choose Category.', SH_NAME ),
						),
						array(
						   "type" => "dropdown",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __("Order By", SH_NAME),
						   "param_name" => "sort",
						   'value' => array_flip( array('date'=>__('Date', SH_NAME),'title'=>__('Title', SH_NAME) ,'name'=>__('Name', SH_NAME) ,'author'=>__('Author', SH_NAME),'comment_count' =>__('Comment Count', SH_NAME),'random' =>__('Random', SH_NAME) ) ),			
						   "description" => __("Enter the sorting order.", SH_NAME),
						),
						array(
						   "type" => "dropdown",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __("Order", SH_NAME),
						   "param_name" => "order",
						   'value' => array_flip(array('ASC'=>__('Ascending', SH_NAME),'DESC'=>__('Descending', SH_NAME) ) ),			
						   "description" => __("Enter the sorting order.", SH_NAME),
						),
						array(
						   "type" => "checkbox",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Show/Hide', SH_NAME ),
						   "param_name" => "show_ratting",
						   'value' => array(__('Show Ratting', SH_NAME ) => true ),
						   "description" => __('Check to show the ratting', SH_NAME )
						),
						array(
						   "type" => "checkbox",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Show/Hide', SH_NAME ),
						   "param_name" => "show_address",
						   'value' => array(__('Show Address', SH_NAME ) => true ),
						   "description" => __('Check to show the address', SH_NAME )
						),
					)
				);
$sh_sc['sh_feature']	=	array(
					"name" => __("App Features", SH_NAME),
					"base" => "sh_feature",
					"class" => "",
					"category" => __('Realtor', SH_NAME),
					"icon" => 'fa-briefcase' ,
					'description' => __('Show Mobile App Features.', SH_NAME),
					"params" => array(
						array(
						   "type" => "attach_image",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Side Image', SH_NAME ),
						   "param_name" => "img",
						   "description" => __('Enter Image Text', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Title', SH_NAME ),
						   "param_name" => "title",
						   "description" => __('Enter the title or leave empty for none.', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "textarea",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Content', SH_NAME ),
						   "param_name" => "content",
						   "description" => __('Enter the content.', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Button Link', SH_NAME ),
						   "param_name" => "btn_link",
						   "description" => __('Enter Button Link', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Button Text', SH_NAME ),
						   "param_name" => "btn_text",
						   "description" => __('Enter Button Text', SH_NAME ),
						   "value" => "",
						),
						
					)
				);
$sh_sc['sh_clients'] = array(
			"name" => __("Clients", SH_NAME),
			"base" => "sh_clients",
			"class" => "",
			"category" => __('Realtor', SH_NAME),
			"icon" => 'fa-user' ,
			'description' => __('show the Clients logo.', SH_NAME),
			"params" => array(
			 	array(
				   "type" => "textfield",
				   "holder" => "div",
				   "class" => "",
				   "heading" => __("Title", SH_NAME),
				   "param_name" => "title",
				   'value' => '',
				   "description" => __("Enter the Title", SH_NAME),
				),
				array(
				   "type" => "textarea",
				   "holder" => "div",
				   "class" => "",
				   "heading" => __("Text", SH_NAME),
				   "param_name" => "text",
				   'value' => '',
				   "description" => __("Enter the Text", SH_NAME),
				),
				array(
				   "type" => "textfield",
				   "holder" => "div",
				   "class" => "",
				   "heading" => __("Number", SH_NAME),
				   "param_name" => "num",
				   'value' => '',
				   "description" => __("Enter the Number of Clients.", SH_NAME),
				),
				
            )
	    );

$sh_sc['sh_map'] = array(
			"name" => __("Google map", SH_NAME),
			"base" => "sh_map",
			"class" => "",
			"category" => __('Realtor', SH_NAME),
			"icon" => 'fa-user' ,
			'description' => __('show the map.', SH_NAME),
			"params" => array(
			 	array(
				   "type" => "textfield",
				   "holder" => "div",
				   "class" => "",
				   "heading" => __("Lattitude", SH_NAME),
				   "param_name" => "lat",
				   'value' => '',
				   "description" => __("Enter the Lattitude", SH_NAME),
				),
				array(
				   "type" => "textfield",
				   "holder" => "div",
				   "class" => "",
				   "heading" => __("Longitude", SH_NAME),
				   "param_name" => "long",
				   'value' => '',
				   "description" => __("Enter the Longitude", SH_NAME),
				),
				array(
				   "type" => "textfield",
				   "holder" => "div",
				   "class" => "",
				   "heading" => __('Number', SH_NAME ),
				   "param_name" => "num",
				   "description" => __('Enter Number of properties to Show.', SH_NAME ),
				   "value" => "",
				),
				array(
				   "type" => "dropdown",
				   "holder" => "div",
				   "class" => "",
				   "heading" => __( 'Category', SH_NAME ),
				   "param_name" => "cat",
				   "value" => array_flip( (array)sh_get_categories( array( 'taxonomy' => 'property_category', 'hide_empty' => FALSE ), true ) ),
				   "description" => __( 'Choose Category.', SH_NAME ),
				),
				array(
				   "type" => "dropdown",
				   "holder" => "div",
				   "class" => "",
				   "heading" => __("Order By", SH_NAME),
				   "param_name" => "sort",
				   'value' => array_flip( array('date'=>__('Date', SH_NAME),'title'=>__('Title', SH_NAME) ,'name'=>__('Name', SH_NAME) ,'author'=>__('Author', SH_NAME),'comment_count' =>__('Comment Count', SH_NAME),'random' =>__('Random', SH_NAME) ) ),			
				   "description" => __("Enter the sorting order.", SH_NAME),
				),
				array(
				   "type" => "dropdown",
				   "holder" => "div",
				   "class" => "",
				   "heading" => __("Order", SH_NAME),
				   "param_name" => "order",
				   'value' => array_flip(array('ASC'=>__('Ascending', SH_NAME),'DESC'=>__('Descending', SH_NAME) ) ),			
				   "description" => __("Enter the sorting order.", SH_NAME),
				),
				
			)
	    );
		
$sh_sc['sh_search2']	=	array(
					"name" => __("Search Box style 2", SH_NAME),
					"base" => "sh_search2",
					"class" => "",
					"category" => __('Realtor', SH_NAME),
					"icon" => 'fa-briefcase' ,
					'description' => __('Show Search Box.', SH_NAME),
					"params" => array(
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Title', SH_NAME ),
						   "param_name" => "title",
						   "value" => "",
						   "description" => __('Enter the title or leave empty for none.', SH_NAME ),
						   
						),
					)
				);
$sh_sc['sh_services2']	=	array(
					"name" => __("Services 2", SH_NAME),
					"base" => "sh_services2",
					"class" => "",
					"category" => __('Realtor', SH_NAME),
					"icon" => 'fa-briefcase' ,
					'description' => __('Show Service.', SH_NAME),
					"params" => array(
						
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Title', SH_NAME ),
						   "param_name" => "title",
						   "description" => __('Enter Title to Show.', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "textarea",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Text', SH_NAME ),
						   "param_name" => "text",
						   "description" => __('Enter Text to Show.', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Number', SH_NAME ),
						   "param_name" => "num",
						   "description" => __('Enter Number of Services to Show.', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Text Limit', SH_NAME ),
						   "param_name" => "text_limit",
						   "description" => __('Enter text limit of Services to Show.', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "dropdown",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __( 'Category', SH_NAME ),
						   "param_name" => "cat",
						   "value" => array_flip( (array)sh_get_categories( array( 'taxonomy' => 'services_category', 'hide_empty' => FALSE ), true ) ),
						   "description" => __( 'Choose Category.', SH_NAME ),
						),
						array(
						   "type" => "dropdown",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __("Order By", SH_NAME),
						   "param_name" => "sort",
						   'value' => array_flip( array('date'=>__('Date', SH_NAME),'title'=>__('Title', SH_NAME) ,'name'=>__('Name', SH_NAME) ,'author'=>__('Author', SH_NAME),'comment_count' =>__('Comment Count', SH_NAME),'random' =>__('Random', SH_NAME) ) ),			
						   "description" => __("Enter the sorting order.", SH_NAME),
						),
						array(
						   "type" => "dropdown",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __("Order", SH_NAME),
						   "param_name" => "order",
						   'value' => array_flip(array('ASC'=>__('Ascending', SH_NAME),'DESC'=>__('Descending', SH_NAME) ) ),			
						   "description" => __("Enter the sorting order.", SH_NAME),
						),
					)
				);
$sh_sc['sh_contact_map'] = array(
			"name" => __("Contact map", SH_NAME),
			"base" => "sh_contact_map",
			"class" => "",
			"category" => __('Realtor', SH_NAME),
			"icon" => 'fa-user' ,
			'description' => __('show the map.', SH_NAME),
			"params" => array(
			 	array(
				   "type" => "textfield",
				   "holder" => "div",
				   "class" => "",
				   "heading" => __("Lattitude", SH_NAME),
				   "param_name" => "lat",
				   'value' => '',
				   "description" => __("Enter the Lattitude", SH_NAME),
				),
				array(
				   "type" => "textfield",
				   "holder" => "div",
				   "class" => "",
				   "heading" => __("Longitude", SH_NAME),
				   "param_name" => "long",
				   'value' => '',
				   "description" => __("Enter the Longitude", SH_NAME),
				),
				array(
				   "type" => "textarea",
				   "holder" => "div",
				   "class" => "",
				   "heading" => __("Mark Address", SH_NAME),
				   "param_name" => "mark_address",
				   'value' => '',
				   "description" => __("Enter the Mark Address", SH_NAME),
				),
			)
	    );

$sh_sc['sh_contact_form']	=	array(
					"name" => __("Contact Form", SH_NAME),
					"base" => "sh_contact_form",
					"class" => "",
					"category" => __('Realtor', SH_NAME),
					"icon" => 'fa-briefcase' ,
					'description' => __('Show Contact Form.', SH_NAME),
					"params" => array(
						
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Title', SH_NAME ),
						   "param_name" => "title",
						   "description" => __('Enter Title to Show.', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "textarea",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Text', SH_NAME ),
						   "param_name" => "text",
						   "description" => __('Enter Text to Show.', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Reciver Email', SH_NAME ),
						   "param_name" => "email",
						   "description" => __('Enter Receiver Email address', SH_NAME ),
						   "value" => "",
						),
					)
				);
$sh_sc['sh_pricing_section']	=	array(
			"name" => __("Pricing Section", SH_NAME),
			"base" => "sh_pricing_section",
			"class" => "",
			"category" => __('Realtor', SH_NAME),
			"icon" => 'icon-wpb-layer-shape-text' ,
			"as_parent" => array('only' => 'sh_pricing_table'), // Use only|except attributes to limit child shortcodes (separate multiple values with comma)
			"content_element" => true,
			"show_settings_on_create" => false,
			'description' => __('Add Number of pricing tables to your theme.', SH_NAME),
			"params" => array(
				array(
				   "type" => "textfield",
				   "holder" => "div",
				   "class" => "",
				   "heading" => __("Title", SH_NAME),
				   "param_name" => "title",
				   "description" => __("Enter the title.", SH_NAME),
				   "value" => "",
				),
				array(
				   "type" => "textarea",
				   "holder" => "div",
				   "class" => "",
				   "heading" => __("Text", SH_NAME),
				   "param_name" => "text",
				   "description" => __("Enter the Text.", SH_NAME),
				   "value" => "",
				),
			
			),
			"js_view" => 'VcColumnView'
		);
$sh_sc['sh_pricing_table']	=	array(
			"name" => __("Pricing Table", SH_NAME),
			"base" => "sh_pricing_table",
			"class" => "",
			"category" => __('Realtor', SH_NAME),
			"icon" => 'icon-wpb-layer-shape-text' ,
			"as_child" => array('only' => 'sh_pricing_section'),// Use only|except attributes to limit child shortcodes (separate multiple values with comma)
			"content_element" => true,
			"show_settings_on_create" => true,
			'description' => __('Add Pricing Table.', SH_NAME),
			"params" => array(
				array(
				   "type" => "textfield",
				   "holder" => "div",
				   "class" => "",
				   "heading" => __("Title", SH_NAME),
				   "param_name" => "title",
				   "description" => __("Enter the title to show.", SH_NAME),
				   "value" => "",
				),
				array(
				   "type" => "textfield",
				   "holder" => "div",
				   "class" => "",
				   "heading" => __("Currency", SH_NAME),
				   "param_name" => "currency",
				   "description" => __("Enter the currency to show", SH_NAME),
				   "value" => "",
				),
				array(
				   "type" => "textfield",
				   "holder" => "div",
				   "class" => "",
				   "heading" => __("Price", SH_NAME),
				   "param_name" => "price",
				   "description" => __("Enter the price to show", SH_NAME),
				   "value" => "",
				),
				array(
				   "type" => "textfield",
				   "holder" => "div",
				   "class" => "",
				   "heading" => __("Package Duration", SH_NAME),
				   "param_name" => "package_duration",
				   "description" => __("Enter the Package duration to show", SH_NAME),
				   "value" => "",
				),
				array(
				   "type" => "textarea",
				   "holder" => "div",
				   "class" => "",
				   "heading" => __("Features", SH_NAME),
				   "param_name" => "feature_str",
				   "description" => __("Enter the features to show one per line.", SH_NAME),
				   "value" => "",
				),
				array(
				   "type" => "textfield",
				   "holder" => "div",
				   "class" => "",
				   "heading" => __("Button Text", SH_NAME),
				   "param_name" => "btn_text",
				   "description" => __("Enter the button text to show", SH_NAME),
				   "value" => "",
				),
				array(
				   "type" => "textfield",
				   "holder" => "div",
				   "class" => "",
				   "heading" => __("Button Link", SH_NAME),
				   "param_name" => "btn_link",
				   "description" => __("Enter the button link to show", SH_NAME),
				   "value" => "",
				),
			
			),
		);
$sh_sc['sh_contact_info']	=	array(
					"name" => __("Contact info", SH_NAME),
					"base" => "sh_contact_info",
					"class" => "",
					"category" => __('Realtor', SH_NAME),
					"icon" => 'fa-briefcase' ,
					'description' => __('Show Contact info.', SH_NAME),
					"params" => array(
						
						array(
						   "type" => "textarea_raw_html",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Address', SH_NAME ),
						   "param_name" => "text",
						   "description" => __('Enter Address to Show.', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Telephone', SH_NAME ),
						   "param_name" => "telephone",
						   "description" => __('Enter Telephone Number.', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Fax', SH_NAME ),
						   "param_name" => "fax",
						   "description" => __('Enter Fax Number.', SH_NAME ),
						   "value" => "",
						),
						array(
						   "type" => "textarea_raw_html",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Working Hours', SH_NAME ),
						   "param_name" => "text2",
						   "description" => __('Enter Working Hours to Show.', SH_NAME ),
						   "value" => "",
						),
					)
				);
$sh_sc['sh_login_form']	=	array(
					"name" => __("Login Form", SH_NAME),
					"base" => "sh_login_form",
					"class" => "",
					"category" => __('Realtor', SH_NAME),
					"icon" => 'fa-briefcase' ,
					'description' => __('Show Login Form.', SH_NAME),
					"params" => array(
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Title', SH_NAME ),
						   "param_name" => "title",
						   "description" => __('Enter Title Number.', SH_NAME ),
						   "value" => "",
						),
					)
				);
$sh_sc['sh_register_form']	=	array(
					"name" => __("Register Form", SH_NAME),
					"base" => "sh_register_form",
					"class" => "",
					"category" => __('Realtor', SH_NAME),
					"icon" => 'fa-briefcase' ,
					'description' => __('Show Register Form.', SH_NAME),
					"params" => array(
						array(
						   "type" => "textfield",
						   "holder" => "div",
						   "class" => "",
						   "heading" => __('Title', SH_NAME ),
						   "param_name" => "title",
						   "description" => __('Enter Title Number.', SH_NAME ),
						   "value" => "",
						),
					)
				);				

				
		

/*----------------------------------------------------------------------------*/
$sh_sc = apply_filters( '_sh_shortcodes_array', $sh_sc );
	
return $sh_sc;